<?php
function generateBankBlock() {
    // Только для внутренних страниц
    $url = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    if ($url === '/' || $url === '') {
        return ''; // не выводим на главной
    }

    $banksFile = 'includes/bank.txt';
    $commentsFile = 'includes/comments.txt';

    if (!file_exists($banksFile) || !file_exists($commentsFile)) {
        return ''; // нет файлов — ничего не делаем
    }

    $banks = file($banksFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $comments = file($commentsFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    if (empty($banks) || empty($comments)) {
        return '';
    }

    $output = '';
    $count = rand(1, 10);
    for ($i = 0; $i < $count; $i++) {
        $bank = $banks[array_rand($banks)];
        $percent = rand(5, 30);
        $comment = $comments[array_rand($comments)];

        $output .= "<p>$bank выдает кредит под $percent процентов $comment</p>\n";
    }

    return "<div class=\"bank-block\">\n" . $output . "</div>";
}
